<?php

/**
 * Class that operate on table 'buybill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class BuybillMySqlDAO implements BuybillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BuybillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM buybill WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM buybill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM buybill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param buybill primary key
     */
    public function delete($buybillid) {
        $sql = 'DELETE FROM buybill WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($buybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BuybillMySql buybill
     */
    public function insert($buybill) {
        $sql = 'INSERT INTO buybill (buybillSerial, buybilldate, buybillsupplierid, buybilltotaldeptbefor, buybilltotaldeptafter, buybilldiscount, buybilldiscountrype, buybilltotalbill, buybillaftertotalbill, buybilltotalpayed, buybillfinalbill, buybillstoreid, buybillsysdate,comment, userid, conditions, buybillclientname, buybillsaveid, buybilldirectpayment, billnameid,payedtax,costcenterid,dailyentryid,delbyuserid,currencyId,taxOfDiscountPer,taxOfDiscountVal,files,client,totalBuyDiscountVal,webApiId,buybilladdition,buybilladditiontrype) VALUES (?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybill->buybillSerial);
        $sqlQuery->set($buybill->buybilldate);
        $sqlQuery->setNumber($buybill->buybillsupplierid);
        $sqlQuery->set($buybill->buybilltotaldeptbefor);
        $sqlQuery->set($buybill->buybilltotaldeptafter);
        $sqlQuery->set($buybill->buybilldiscount);
        $sqlQuery->setNumber($buybill->buybilldiscountrype);
        $sqlQuery->set($buybill->buybilltotalbill);
        $sqlQuery->set($buybill->buybillaftertotalbill);
        $sqlQuery->set($buybill->buybilltotalpayed);
        $sqlQuery->set($buybill->buybillfinalbill);
        $sqlQuery->setNumber($buybill->buybillstoreid);
        $sqlQuery->set($buybill->buybillsysdate);
        $sqlQuery->set($buybill->comment);
        $sqlQuery->setNumber($buybill->userid);
        $sqlQuery->setNumber($buybill->conditions);
        $sqlQuery->set($buybill->buybillclientname);
        $sqlQuery->setNumber($buybill->buybillsaveid);
        $sqlQuery->setNumber($buybill->buybilldirectpayment);
        $sqlQuery->setNumber($buybill->billnameid);
        $sqlQuery->set($buybill->payedtax);
        $sqlQuery->set($buybill->costcenterid);
        $sqlQuery->set($buybill->dailyentryid);
        $sqlQuery->setNumber((int) $buybill->delbyuserid);
        $sqlQuery->setNumber((int) $buybill->currencyId);
        $sqlQuery->setNumber((float) $buybill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $buybill->taxOfDiscountVal);
        $sqlQuery->set($buybill->files);
        $sqlQuery->setNumber((int) $buybill->client);
        $sqlQuery->setNumber((float) $buybill->totalBuyDiscountVal);
        $sqlQuery->setNumber((int) $buybill->webApiId);
        $sqlQuery->setNumber((float) $buybill->buybilladdition);
        $sqlQuery->setNumber((int) $buybill->buybilladditiontrype);


        $id = $this->executeInsert($sqlQuery);
        $buybill->buybillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BuybillMySql buybill
     */
    public function update($buybill) {
        $sql = 'UPDATE buybill SET buybillSerial = ?, buybilldate = ?, buybillsupplierid = ?, buybilltotaldeptbefor = ?, buybilltotaldeptafter = ?, buybilldiscount = ?, buybilldiscountrype = ?, buybilltotalbill = ?, buybillaftertotalbill = ?, buybilltotalpayed = ?, buybillfinalbill = ?, buybillstoreid = ?, buybillsysdate = ?,comment = ?, userid = ?, conditions = ?, buybillclientname = ?, buybillsaveid = ?, buybilldirectpayment = ?, billnameid = ?, dailyentryid = ?,delbyuserid = ?,currencyId=?,taxOfDiscountPer=?,taxOfDiscountVal=?,files=?,totalBuyDiscountVal=?,buybilladdition=?,buybilladditiontrype=? WHERE buybillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($buybill->buybillSerial);
        $sqlQuery->set($buybill->buybilldate);
        $sqlQuery->setNumber($buybill->buybillsupplierid);
        $sqlQuery->set($buybill->buybilltotaldeptbefor);
        $sqlQuery->set($buybill->buybilltotaldeptafter);
        $sqlQuery->set($buybill->buybilldiscount);
        $sqlQuery->setNumber($buybill->buybilldiscountrype);
        $sqlQuery->set($buybill->buybilltotalbill);
        $sqlQuery->set($buybill->buybillaftertotalbill);
        $sqlQuery->set($buybill->buybilltotalpayed);
        $sqlQuery->set($buybill->buybillfinalbill);
        $sqlQuery->setNumber($buybill->buybillstoreid);
        $sqlQuery->set($buybill->buybillsysdate);
        $sqlQuery->set($buybill->comment);
        $sqlQuery->setNumber($buybill->userid);
        $sqlQuery->setNumber($buybill->conditions);
        $sqlQuery->set($buybill->buybillclientname);
        $sqlQuery->setNumber($buybill->buybillsaveid);
        $sqlQuery->setNumber($buybill->buybilldirectpayment);
        $sqlQuery->setNumber($buybill->billnameid);
        $sqlQuery->set($buybill->dailyentryid);
        $sqlQuery->setNumber((int) $buybill->delbyuserid);
        $sqlQuery->setNumber((int) $buybill->currencyId);
        $sqlQuery->setNumber((float) $buybill->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $buybill->taxOfDiscountVal);
        $sqlQuery->set($buybill->files);
        $sqlQuery->setNumber((float) $buybill->totalBuyDiscountVal);
        $sqlQuery->setNumber((float) $buybill->buybilladdition);
        $sqlQuery->setNumber((int) $buybill->buybilladditiontrype);


        $sqlQuery->setNumber($buybill->buybillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM buybill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuybillSerial($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldate($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsupplierid($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotaldeptafter($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscount($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldiscountrype($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalbill($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillaftertotalbill($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilltotalpayed($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillfinalbill($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillstoreid($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsysdate($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM buybill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCondition($value) {
        $sql = 'SELECT * FROM buybill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillclientname($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybillsaveid($value) {
        $sql = 'SELECT * FROM buybill WHERE buybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuybilldirectpayment($value) {
        $sql = 'SELECT * FROM buybill WHERE buybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM buybill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuybillSerial($value) {
        $sql = 'DELETE FROM buybill WHERE buybillSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldate($value) {
        $sql = 'DELETE FROM buybill WHERE buybilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsupplierid($value) {
        $sql = 'DELETE FROM buybill WHERE buybillsupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotaldeptbefor($value) {
        $sql = 'DELETE FROM buybill WHERE buybilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotaldeptafter($value) {
        $sql = 'DELETE FROM buybill WHERE buybilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscount($value) {
        $sql = 'DELETE FROM buybill WHERE buybilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldiscountrype($value) {
        $sql = 'DELETE FROM buybill WHERE buybilldiscountrype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalbill($value) {
        $sql = 'DELETE FROM buybill WHERE buybilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillaftertotalbill($value) {
        $sql = 'DELETE FROM buybill WHERE buybillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilltotalpayed($value) {
        $sql = 'DELETE FROM buybill WHERE buybilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillfinalbill($value) {
        $sql = 'DELETE FROM buybill WHERE buybillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillstoreid($value) {
        $sql = 'DELETE FROM buybill WHERE buybillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsysdate($value) {
        $sql = 'DELETE FROM buybill WHERE buybillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM buybill WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCondition($value) {
        $sql = 'DELETE FROM buybill WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillclientname($value) {
        $sql = 'DELETE FROM buybill WHERE buybillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybillsaveid($value) {
        $sql = 'DELETE FROM buybill WHERE buybillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuybilldirectpayment($value) {
        $sql = 'DELETE FROM buybill WHERE buybilldirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM buybill WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BuybillMySql
     */
    protected function readRow($row) {
        $buybill = new Buybill();

        $buybill->buybillid = isset($row['buybillid']) ? $row['buybillid'] : '';
        $buybill->buybillSerial = isset($row['buybillSerial']) ? $row['buybillSerial'] : '';
        $buybill->buybilldate = isset($row['buybilldate']) ? $row['buybilldate'] : '';
        $buybill->buybillsupplierid = isset($row['buybillsupplierid']) ? $row['buybillsupplierid'] : '';
        $buybill->buybilltotaldeptbefor = isset($row['buybilltotaldeptbefor']) ? $row['buybilltotaldeptbefor'] : '';
        $buybill->buybilltotaldeptafter = isset($row['buybilltotaldeptafter']) ? $row['buybilltotaldeptafter'] : '';
        $buybill->buybilldiscount = isset($row['buybilldiscount']) ? $row['buybilldiscount'] : '';
        $buybill->buybilldiscountrype = isset($row['buybilldiscountrype']) ? $row['buybilldiscountrype'] : '';
        $buybill->buybilltotalbill = isset($row['buybilltotalbill']) ? $row['buybilltotalbill'] : '';
        $buybill->buybillaftertotalbill = isset($row['buybillaftertotalbill']) ? $row['buybillaftertotalbill'] : '';
        $buybill->buybilltotalpayed = isset($row['buybilltotalpayed']) ? $row['buybilltotalpayed'] : '';
        $buybill->buybillfinalbill = isset($row['buybillfinalbill']) ? $row['buybillfinalbill'] : '';
        $buybill->buybillstoreid = isset($row['buybillstoreid']) ? $row['buybillstoreid'] : '';
        $buybill->buybillsysdate = isset($row['buybillsysdate']) ? $row['buybillsysdate'] : '';
        $buybill->comment = isset($row['comment']) ? $row['comment'] : '';
        $buybill->userid = isset($row['userid']) ? $row['userid'] : '';
        $buybill->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $buybill->buybillclientname = isset($row['buybillclientname']) ? $row['buybillclientname'] : '';
        $buybill->buybillsaveid = isset($row['buybillsaveid']) ? $row['buybillsaveid'] : '';
        $buybill->buybilldirectpayment = isset($row['buybilldirectpayment']) ? $row['buybilldirectpayment'] : '';
        $buybill->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';

        $buybill->deletedbuyid = isset($row['deletedbuyid']) ? $row['deletedbuyid'] : '';
        $buybill->controlname = isset($row['controlname']) ? $row['controlname'] : '';

        $buybill->payedtax = isset($row['payedtax']) ? $row['payedtax'] : '';
        $buybill->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';






        //required
        $buybill->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $buybill->supplierdebt = isset($row['supplierdebt']) ? $row['supplierdebt'] : '';
        $buybill->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $buybill->username = isset($row['username']) ? $row['username'] : '';
        $buybill->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';

        $buybill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $buybill->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';
        $buybill->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';
        $buybill->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $buybill->currencyName = isset($row['currencyName']) ? $row['currencyName'] : '';
        $buybill->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $buybill->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $buybill->files = isset($row['files']) ? $row['files'] : '';
        $buybill->allGenTotal = isset($row['allGenTotal']) ? $row['allGenTotal'] : '';
        $buybill->client = isset($row['client']) ? $row['client'] : '';
        $buybill->totalBuyDiscountVal = isset($row['totalBuyDiscountVal']) ? $row['totalBuyDiscountVal'] : '';
        $buybill->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $buybill->buybilladdition = isset($row['buybilladdition']) ? $row['buybilladdition'] : '';
        $buybill->buybilladditiontrype = isset($row['buybilladditiontrype']) ? $row['buybilladditiontrype'] : '';


        return $buybill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BuybillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>